unit QuadraticClass;

interface

uses sysUtils, Math;

type
 TQuadratic = class
   private
    a, b, c : Integer;
   function calculateDiscriminant: Integer;
   public
   constructor create; overload;
   constructor create(a,b,c: Integer); overload;
   function hasRealRoots: Boolean;
   function hasRationalRoots: Boolean;
   function calculateRoots: String;
   function tostring:String;
 end;

implementation

{ TQuadratic }

function TQuadratic.calculateDiscriminant: Integer;
begin
  Result := b*b - 4*a*c;
end;

function TQuadratic.calculateRoots: String;
var
  rootString: string;
  root1, root2 : double;
begin
  root1 := (-1*b + sqrt(calculateDiscriminant))/(2*a);
  root2 := (-1*b - sqrt(calculateDiscriminant))/(2*a);
  rootString := 'x1 = '+ Format('%f',[root1])+' : '+
                'x2 = '+ Format('%f',[root2]);
  result := rootString;
end;

constructor TQuadratic.create(a, b, c: Integer);
begin
  Self.a := a;
  Self.b := b;
  Self.c := c;
end;

constructor TQuadratic.create;
begin

end;

function TQuadratic.hasRationalRoots: Boolean;
var
  delta : Integer;
begin
  delta := calculateDiscriminant;
  Result := trunc(sqrt(delta))*trunc(sqrt(delta))=delta;
end;

function TQuadratic.hasRealRoots: Boolean;
begin
  Result := (calculateDiscriminant >= 0);
end;

function TQuadratic.tostring: String;
var
  aString: String;
  bString: String;
  cString: String;
begin
  aString :=IntToStr(a)+'x'+chr(178);
  if b > 0 then
    bString:=  '+'+IntToStr(b)+'x'
  else if b < 0 then
       bString := IntToStr(b)+'x'
       else
       bString := '';
  if c > 0 then
    cString:=  '+'+IntToStr(c)
  else if c = 0 then
       cString := ''
       else
       cString := IntToStr(c);
  Result := aString + bString + cString + '= 0';
  end;

end.
